unit Unit1; 

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, LResources, Forms, Controls, Graphics, Dialogs,
  ComCtrls, StdCtrls;

type

  { TForm1 }

  TForm1 = class(TForm)
    ComboBox1: TComboBox;
    ImageList1: TImageList;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    ListBox1: TListBox;
    StatusBar1: TStatusBar;
    TreeView1: TTreeView;
    procedure ComboBox1KeyPress(Sender: TObject; var Key: char);
    procedure ComboBox1Select(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure TreeView1Change(Sender: TObject; Node: TTreeNode);
    procedure LoadListGroup(namefile: string);
  private
    { private declarations }
  public
    { public declarations }
  end; 

var
  Form1: TForm1;

implementation

{ TForm1 }

procedure TForm1.FormCreate(Sender: TObject);
var
  i: integer;
begin
  with TreeView1 do
  begin
    Images:= ImageList1;
    ExpandSignType:= tvestPlusMinus;
    Items.Clear;
    Items.Add(nil, 'Ректор');
    Items.AddChild(Items.Item[0], 'Проректор по учебной работе');
    Items.AddChild(Items.Item[1], 'Учебная часть');
    Items.AddChild(Items.Item[1], 'Факультеты');
    Items.AddChild(Items.Item[3], 'Кафедры');
    Items.AddChild(Items.Item[4], 'Преподаватели');
    Items.AddChild(Items.Item[3], 'Студенты');
    Items.AddChild(Items.Item[6], 'Группы');
    Items.AddChild(Items.Item[0], 'Проректор по науке');
    Items.AddChild(Items.Item[8], 'Институт прикладных исследований');
    Items.AddChild(Items.Item[8], 'Отдел аспирантуры');
    Items.AddChild(Items.Item[0], 'Проректор по экономике');
    Items.AddChild(Items.Item[11], 'Отдел внешних связей');
    Items.AddChild(Items.Item[0], 'Проректор по АХЧ');
    for i:= 0 to Items.Count - 1 do
    begin
      Items.Item[i].ImageIndex:= 0;
      Items.Item[i].SelectedIndex:= 1;
    end;
    FullExpand;
  end;
  Label1.Caption:= 'Выберите группу';
  Label2.Caption:= '';
  Label3.Caption:= 'Структура университета';
  Label1.Visible:= false;
  Label2.Visible:= false;
  ComboBox1.Visible:= false;
  ListBox1.Visible:= false;
end;

procedure TForm1.TreeView1Change(Sender: TObject; Node: TTreeNode);
begin
  StatusBar1.SimpleText:= 'Выбран: ' + Node.Text;
  if Node.AbsoluteIndex = 7 then
  begin
    Label1.Visible:= true;
    ComboBox1.Visible:= true;
    ComboBox1.SetFocus;
    ComboBox1.ItemIndex:= 0;
  end
  else
  begin
    Label1.Visible:= false;
    Label2.Visible:= false;
    ComboBox1.Visible:= false;
    ListBox1.Visible:= false;
  end;
end;

procedure TForm1.ComboBox1Select(Sender: TObject);
begin
  with ComboBox1 do
  begin
    Label2.Visible:= true;
    Label2.Caption:='Список группы ' + Text;
    ListBox1.Visible:= true;
    case ItemIndex of
    0: LoadListGroup('List1.txt');
    1: LoadListGroup('List2.txt');
    2: LoadListGroup('List3.txt');
    else
      ShowMessage('Группа не выбрана');
    end;
  end;
end;

procedure TForm1.LoadListGroup(namefile: string);
var
  tfile: TStringList;
  str: string;
begin
  tfile:= TStringList.Create;
  tfile.LoadFromFile(namefile);
  str:= tfile.Text;
  {$IFDEF WINDOWS}
    str:= SysToUTF8(str); // преобразование в кодировку UTF-8
  {$ENDIF}
  with ListBox1 do
  begin
    Items.Text:= str;
  end;
  tfile.Free;
  ListBox1.Sorted:= true;
end;

procedure TForm1.ComboBox1KeyPress(Sender: TObject; var Key: char);
begin
  if Key = #13 then
  begin
    ComboBox1Select(Sender);
    Key:=#0;
  end;
end;

initialization
  {$I unit1.lrs}

end.

